/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.UpgradeCallableReferences;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhaseDescription(name="JvmUpgradeCallableReferences")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmUpgradeCallableReferences;", "Lorg/jetbrains/kotlin/backend/common/lower/UpgradeCallableReferences;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "jvmSymbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "processCallExpression", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "copyNecessaryAttributes", "", "oldReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "newReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "backend.jvm.lower"})
public final class JvmUpgradeCallableReferences
extends UpgradeCallableReferences {
    @NotNull
    private final JvmSymbols jvmSymbols;

    public JvmUpgradeCallableReferences(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2, true, true, true, true, true);
        this.jvmSymbols = context2.getSymbols();
    }

    @Override
    @NotNull
    public IrElement processCallExpression(@NotNull IrTransformer<? super IrDeclarationParent> $this$processCallExpression, @NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
        Intrinsics.checkNotNullParameter($this$processCallExpression, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (Intrinsics.areEqual(function2.getSymbol(), this.jvmSymbols.getIndyLambdaMetafactoryIntrinsic())) {
            Iterator iterator2 = ((Iterable)expression2.getArguments()).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                IrElement irElement;
                int i2 = n2++;
                IrExpression element = (IrExpression)iterator2.next();
                IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = expression2.getArguments();
                if (i2 == 1) {
                    IrExpression irExpression = element;
                    if (irExpression != null) {
                        irExpression.transformChildren($this$processCallExpression, data);
                    }
                    irElement = element;
                } else {
                    IrExpression irExpression = element;
                    irElement = irExpression != null ? irExpression.transform($this$processCallExpression, data) : null;
                }
                valueArgumentsList.set(i2, irElement);
            }
            return expression2;
        }
        expression2.transformChildren($this$processCallExpression, data);
        return expression2;
    }

    @Override
    protected void copyNecessaryAttributes(@NotNull IrFunctionReference oldReference, @NotNull IrRichFunctionReference newReference) {
        Intrinsics.checkNotNullParameter(oldReference, "oldReference");
        Intrinsics.checkNotNullParameter(newReference, "newReference");
        JvmIrAttributesKt.setLocalClassType(newReference, JvmIrAttributesKt.getLocalClassType(oldReference));
    }
}

