/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;

public final class NbClipboard
extends ExClipboard
implements LookupListener,
FlavorListener,
AWTEventListener {
    private static final Logger log = Logger.getLogger(NbClipboard.class.getName());
    private final ThreadLocal<Boolean> FIRING = new ThreadLocal();
    private Clipboard systemClipboard;
    private ExClipboard.Convertor[] convertors;
    private Lookup.Result<ExClipboard.Convertor> result;
    final boolean slowSystemClipboard;
    private Transferable last;
    private long lastWindowActivated;
    private long lastWindowDeactivated;
    private Reference<Object> lastWindowDeactivatedSource = new WeakReference<Object>(null);
    private volatile Task setContentsTask = Task.EMPTY;
    private volatile Task getContentsTask = Task.EMPTY;
    private boolean anyWindowIsActivated = true;
    private static final RequestProcessor RP = new RequestProcessor("System clipboard synchronizer");

    public NbClipboard() {
        this(Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    NbClipboard(Clipboard clipboard) {
        super("NBClipboard");
        this.systemClipboard = clipboard;
        this.result = Lookup.getDefault().lookupResult(ExClipboard.Convertor.class);
        this.result.addLookupListener((LookupListener)this);
        clipboard.addFlavorListener(this);
        this.resultChanged(null);
        this.slowSystemClipboard = System.getProperty("netbeans.slow.system.clipboard.hack") != null ? Boolean.getBoolean("netbeans.slow.system.clipboard.hack") : !Utilities.isMac();
        if (System.getProperty("sun.awt.datatransfer.timeout") == null) {
            System.setProperty("sun.awt.datatransfer.timeout", "1000");
        }
        if (this.slowSystemClipboard) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    protected synchronized ExClipboard.Convertor[] getConvertors() {
        return this.convertors;
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        Collection collection = this.result.allInstances();
        ExClipboard.Convertor[] convertorArray = new ExClipboard.Convertor[collection.size()];
        this.convertors = collection.toArray(convertorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        NbClipboard nbClipboard = this;
        synchronized (nbClipboard) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "setContents called with: ");
                this.logFlavors(transferable, Level.FINER, log.isLoggable(Level.FINEST));
            }
            transferable = this.convert(transferable);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "After conversion:");
                this.logFlavors(transferable, Level.FINER, log.isLoggable(Level.FINEST));
            }
            if (this.slowSystemClipboard) {
                if (this.contents != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.contents);
                }
                ClipboardOwner clipboardOwner2 = this.owner;
                Transferable transferable2 = this.contents;
                this.owner = clipboardOwner;
                this.contents = transferable;
                if (clipboardOwner2 != null && clipboardOwner2 != clipboardOwner) {
                    EventQueue.invokeLater(() -> clipboardOwner2.lostOwnership((Clipboard)((Object)this), transferable2));
                }
            } else {
                if (this.last != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.last);
                }
                this.last = transferable;
            }
            this.scheduleSetContents(transferable, clipboardOwner, 0);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents(Object object) {
        try {
            Transferable transferable;
            log.log(Level.FINE, "getContents, slowSystemClipboard: {0}", this.slowSystemClipboard);
            if (this.slowSystemClipboard && !RP.isRequestProcessorThread()) {
                boolean bl;
                int n = Integer.getInteger("sun.awt.datatransfer.timeout", 1000);
                if (n > 0 && !Boolean.TRUE.equals(this.FIRING.get()) && !(bl = this.scheduleGetFromSystemClipboard(false).waitFinished((long)n))) {
                    log.log(Level.FINE, "Time out waiting for sync with system clipboard for {0} ms", n);
                }
                transferable = super.getContents(object);
            } else {
                this.setContentsTask.waitFinished();
                this.getContentsTask.waitFinished();
                log.log(Level.FINE, "after syncTask clipboard wait");
                try {
                    transferable = this.systemClipboard.getContents(object);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    log.log(Level.INFO, "System clipboard not available.", throwable);
                    transferable = null;
                }
            }
            NbClipboard nbClipboard = this;
            synchronized (nbClipboard) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "getContents by {0}", object);
                    this.logFlavors(transferable, Level.FINE, log.isLoggable(Level.FINEST));
                }
                if (transferable == null) {
                    return null;
                }
                Transferable transferable2 = this.convert(transferable);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "getContents by {0}", object);
                    this.logFlavors(transferable2, Level.FINE, log.isLoggable(Level.FINEST));
                    transferable2 = new LoggableTransferable(transferable2);
                }
                return transferable2;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(NbClipboard.class.getName()).log(Level.WARNING, null, interruptedException);
            return null;
        }
        catch (Throwable throwable) {
            Exceptions.printStackTrace((Throwable)throwable);
            return null;
        }
    }

    public FlavorListener[] getFlavorListeners() {
        return new FlavorListener[0];
    }

    public synchronized void addFlavorListener(FlavorListener flavorListener) {
        Boolean bl = this.FIRING.get();
        try {
            this.FIRING.set(true);
            super.addFlavorListener(flavorListener);
        }
        finally {
            this.FIRING.set(bl);
        }
    }

    private void scheduleSetContents(Transferable transferable, ClipboardOwner clipboardOwner, int n) {
        this.setContentsTask = RP.post((Runnable)new SetContents(transferable, clipboardOwner), n);
    }

    private Task scheduleGetFromSystemClipboard(boolean bl) {
        this.getContentsTask = RP.post((Runnable)new GetContents(bl));
        return this.getContentsTask;
    }

    final void waitFinished() {
        this.setContentsTask.waitFinished();
        this.getContentsTask.waitFinished();
    }

    final void activateWindowHack(boolean bl) {
        this.lastWindowActivated = System.currentTimeMillis();
        if (bl) {
            this.scheduleGetFromSystemClipboard(true);
        }
    }

    private void logFlavors(Transferable transferable, Level level, boolean bl) {
        if (transferable == null) {
            log.log(level, "  no clipboard contents");
        } else if (bl) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                stringBuilder.append("  ").append(i).append(" = ").append(dataFlavorArray[i]);
                try {
                    stringBuilder.append(" contains: ").append(transferable.getTransferData(dataFlavorArray[i]));
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    log.log(level, "Can't convert to " + dataFlavorArray[i], exception);
                }
                stringBuilder.append("\n");
            }
            log.log(level, stringBuilder.toString());
        } else {
            log.log(level, " clipboard contains data");
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        if (!this.anyWindowIsActivated) {
            return;
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireChange() {
        Boolean bl = this.FIRING.get();
        try {
            this.FIRING.set(true);
            FlavorEvent flavorEvent = new FlavorEvent((Clipboard)((Object)this));
            this.fireClipboardChange();
            for (FlavorListener flavorListener : super.getFlavorListeners()) {
                flavorListener.flavorsChanged(flavorEvent);
            }
        }
        finally {
            this.FIRING.set(bl);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof WindowEvent)) {
            return;
        }
        if (aWTEvent.getID() == 206) {
            this.lastWindowDeactivated = System.currentTimeMillis();
            this.lastWindowDeactivatedSource = new WeakReference<Object>(aWTEvent.getSource());
            this.anyWindowIsActivated = false;
            if (Utilities.isWindows()) {
                this.systemClipboard.removeFlavorListener(this);
            }
        }
        if (aWTEvent.getID() == 205) {
            if (Utilities.isWindows()) {
                this.systemClipboard.addFlavorListener(this);
                this.fireChange();
            }
            this.anyWindowIsActivated = true;
            if (System.currentTimeMillis() - this.lastWindowDeactivated < 100L && aWTEvent.getSource() == this.lastWindowDeactivatedSource.get()) {
                this.activateWindowHack(false);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "window activated scheduling update");
            }
            this.scheduleGetFromSystemClipboard(true);
        }
    }

    private synchronized void superSetContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (this.contents != null) {
            NbClipboard.transferableOwnershipLost((Transferable)this.contents);
        }
        ClipboardOwner clipboardOwner2 = this.owner;
        Transferable transferable2 = this.contents;
        this.owner = clipboardOwner;
        this.contents = transferable;
        if (clipboardOwner2 != null && clipboardOwner2 != this.owner) {
            EventQueue.invokeLater(() -> clipboardOwner2.lostOwnership((Clipboard)((Object)this), transferable2));
        }
    }

    private final class SetContents
    implements Runnable {
        private final Transferable cnts;
        private final ClipboardOwner ownr;

        SetContents(Transferable transferable, ClipboardOwner clipboardOwner) {
            this.cnts = transferable;
            this.ownr = clipboardOwner;
        }

        @Override
        public void run() {
            try {
                NbClipboard.this.systemClipboard.setContents(this.cnts, this.ownr);
            }
            catch (IllegalStateException illegalStateException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "systemClipboard not available", illegalStateException);
                } else {
                    log.log(Level.INFO, "systemClipboard#setContents threw IllegalStateException");
                }
                NbClipboard.this.scheduleSetContents(this.cnts, this.ownr, 100);
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "systemClipboard updated:");
                NbClipboard.this.logFlavors(this.cnts, Level.FINE, log.isLoggable(Level.FINEST));
            }
        }
    }

    private final class GetContents
    implements Runnable {
        private final boolean notify;

        public GetContents(boolean bl) {
            this.notify = bl;
        }

        @Override
        public void run() {
            log.fine("Running update");
            try {
                Transferable transferable = null;
                long l = System.currentTimeMillis();
                for (int i = 0; i < 50; ++i) {
                    try {
                        transferable = NbClipboard.this.systemClipboard.getContents(this);
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (i == 49 || System.currentTimeMillis() - l > 980L) {
                            throw illegalStateException;
                        }
                        log.log(Level.INFO, "systemClipboard#getContents threw IllegalStateException (try: {0})", i + 1);
                        Thread.sleep(20L);
                        continue;
                    }
                }
                NbClipboard.this.superSetContents(transferable, null);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "internal clipboard updated:");
                    NbClipboard.this.logFlavors(transferable, Level.FINE, log.isLoggable(Level.FINEST));
                }
                if (this.notify) {
                    NbClipboard.this.fireChange();
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (InterruptedException | RuntimeException exception) {
                log.log(Level.INFO, "systemClipboard not available", exception);
            }
        }
    }

    private final class LoggableTransferable
    implements Transferable {
        private final Transferable delegate;

        public LoggableTransferable(Transferable transferable) {
            this.delegate = transferable;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            log.log(Level.FINE, "Request for flavor: {0}", dataFlavor);
            Object object = this.delegate.getTransferData(dataFlavor);
            log.log(Level.FINE, "Returning value: {0}", object);
            return object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.delegate.getTransferDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            boolean bl = this.delegate.isDataFlavorSupported(dataFlavor);
            log.log(Level.FINE, "isDataFlavorSupported: {0} result: {1}", new Object[]{dataFlavor, bl});
            return bl;
        }
    }
}

