/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.net.URI;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class AlwaysFollowAndPreserveMethodRedirectStrategy
extends DefaultRedirectStrategy {
    protected boolean isRedirectable(String method) {
        return true;
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri = this.getLocationURI(request, response, context);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uri);
        }
        if (method.equalsIgnoreCase("POST")) {
            return this.copyEntity((HttpEntityEnclosingRequestBase)new HttpPost(uri), request);
        }
        if (method.equalsIgnoreCase("PUT")) {
            return this.copyEntity((HttpEntityEnclosingRequestBase)new HttpPut(uri), request);
        }
        if (method.equalsIgnoreCase("DELETE")) {
            return new HttpDelete(uri);
        }
        if (method.equalsIgnoreCase("TRACE")) {
            return new HttpTrace(uri);
        }
        if (method.equalsIgnoreCase("OPTIONS")) {
            return new HttpOptions(uri);
        }
        if (method.equalsIgnoreCase("PATCH")) {
            return this.copyEntity((HttpEntityEnclosingRequestBase)new HttpPatch(uri), request);
        }
        return new HttpGet(uri);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

