/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.Incubating;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.internal.Pair;
import org.jspecify.annotations.Nullable;

public abstract class IncubatingAttributesChecker {
    public static <T> boolean isIncubating(Attribute<T> attribute) {
        return IncubatingAttributesChecker.isIncubatingAttributeValue(attribute.getType(), null);
    }

    public static <T> boolean isIncubating(Attribute<T> key, @Nullable T value) {
        if (IncubatingAttributesChecker.isIncubatingAttributeInterface(key)) {
            return true;
        }
        return IncubatingAttributesChecker.isIncubatingAttributeValue(key.getType(), value);
    }

    public static boolean isAnyIncubating(AttributeContainer attributes) {
        return attributes.keySet().stream().map(k -> Pair.of((Object)k, (Object)attributes.getAttribute(k))).anyMatch(IncubatingAttributesChecker::isIncubating);
    }

    private static <T> boolean isIncubating(Pair<Attribute<T>, T> attributePair) {
        return IncubatingAttributesChecker.isIncubating(Objects.requireNonNull((Attribute)attributePair.getLeft()), attributePair.getRight());
    }

    private static <T> boolean isIncubatingAttributeInterface(Attribute<T> key) {
        return IncubatingAttributesChecker.isAnnotatedWithIncubating(key.getType());
    }

    private static <T> boolean isIncubatingAttributeValue(Class<T> type, @Nullable T value) {
        String valueStr = value != null ? value.toString() : null;
        return IncubatingAttributesChecker.getIncubatingFields(type).stream().map(IncubatingAttributesChecker::getFieldValue).anyMatch(Predicate.isEqual(valueStr));
    }

    private static Object getFieldValue(Field f) {
        try {
            return f.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error reading field: " + f.getName() + " on type: " + f.getType().getName(), e);
        }
    }

    private static List<Field> getIncubatingFields(Class<?> type) {
        return Arrays.stream(type.getDeclaredFields()).filter(IncubatingAttributesChecker::isAnnotatedWithIncubating).collect(Collectors.toList());
    }

    private static boolean isAnnotatedWithIncubating(AnnotatedElement element) {
        return element.isAnnotationPresent(Incubating.class);
    }
}

