/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Stack;
import org.gradle.internal.classpath.InstrumentedGroovyCallsTracker;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultInstrumentedGroovyCallsTracker
implements InstrumentedGroovyCallsTracker {
    private final Stack<EntryPointCallSiteImpl> callSiteStack = new Stack();

    @Override
    public InstrumentedGroovyCallsTracker.EntryPointCallSite enterCall(String callerClassName, String callableName, InstrumentedGroovyCallsTracker.CallKind callKind) {
        EntryPointCallSiteImpl entryPoint = new EntryPointCallSiteImpl(callableName, callerClassName, callKind);
        this.callSiteStack.push(entryPoint);
        return entryPoint;
    }

    @Override
    public void leaveCall(InstrumentedGroovyCallsTracker.EntryPointCallSite entryPoint) {
        InstrumentedGroovyCallsTracker.EntryPointCallSite top;
        if (this.callSiteStack.isEmpty()) {
            this.throwMismatchedLeaveCallException(entryPoint);
        }
        if ((top = (InstrumentedGroovyCallsTracker.EntryPointCallSite)this.callSiteStack.peek()) != entryPoint) {
            this.throwMismatchedLeaveCallException(entryPoint);
        }
        this.callSiteStack.pop();
    }

    private void throwMismatchedLeaveCallException(InstrumentedGroovyCallsTracker.EntryPointCallSite entryPoint) {
        if (!(entryPoint instanceof EntryPointCallSiteImpl)) {
            throw new IllegalArgumentException("Unexpected entry point call site.");
        }
        if (this.callSiteStack.isEmpty()) {
            throw new IllegalStateException("leaveCall invoked with an empty call stack");
        }
        EntryPointCallSiteImpl entryPointImpl = (EntryPointCallSiteImpl)entryPoint;
        EntryPointCallSiteImpl top = this.callSiteStack.peek();
        throw new IllegalStateException("Illegal state of the instrumented Groovy call tracker. Expected the call to " + entryPointImpl.getCallableName() + " from " + entryPointImpl.getCallerClassName() + " on top, got a call to " + top.getCallableName() + " from " + top.getCallerClassName());
    }

    @Override
    public @Nullable String findCallerForCurrentCallIfNotIntercepted(String callableName, InstrumentedGroovyCallsTracker.CallKind kind) {
        if (this.callSiteStack.isEmpty()) {
            return null;
        }
        EntryPointCallSiteImpl top = this.callSiteStack.peek();
        if (!callableName.equals(top.getCallableName())) {
            return null;
        }
        if (kind != top.getKind()) {
            return null;
        }
        if (top.isMatchedAtDispatchSite()) {
            return null;
        }
        return top.getCallerClassName();
    }

    @Override
    public void markCurrentCallAsIntercepted(String callableName, InstrumentedGroovyCallsTracker.CallKind kind) {
        String result = this.findCallerForCurrentCallIfNotIntercepted(callableName, kind);
        if (result == null) {
            throw new IllegalStateException("Failed to match the current call: tried to intercept " + callableName + ", but " + (this.callSiteStack.empty() ? "there is no current call" : "the current call is " + this.callSiteStack.peek().getCallableName()));
        }
        this.callSiteStack.peek().markedAsMatchedAtDispatchSite();
    }

    @NullMarked
    private static class EntryPointCallSiteImpl
    implements InstrumentedGroovyCallsTracker.EntryPointCallSite {
        private final String callableName;
        private final String callerClassName;
        private final InstrumentedGroovyCallsTracker.CallKind kind;
        private boolean isMatchedAtDispatchSite = false;

        public EntryPointCallSiteImpl(String callableName, String callerClassName, InstrumentedGroovyCallsTracker.CallKind kind) {
            this.callableName = callableName;
            this.callerClassName = callerClassName;
            this.kind = kind;
        }

        public String getCallableName() {
            return this.callableName;
        }

        public String getCallerClassName() {
            return this.callerClassName;
        }

        public InstrumentedGroovyCallsTracker.CallKind getKind() {
            return this.kind;
        }

        public boolean isMatchedAtDispatchSite() {
            return this.isMatchedAtDispatchSite;
        }

        public void markedAsMatchedAtDispatchSite() {
            if (this.isMatchedAtDispatchSite) {
                throw new IllegalStateException("Cannot match a single call more than once");
            }
            this.isMatchedAtDispatchSite = true;
        }
    }
}

