/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.nio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import org.gradle.internal.file.FilePermissionHandler;
import org.gradle.internal.file.nio.PosixJdk7FilePermissionHandler;

public class NioFilePermissions {
    public static FilePermissionHandler createFilePermissionHandler() {
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            return new PosixJdk7FilePermissionHandler();
        }
        return new FilePermissionHandler(){

            @Override
            public int getUnixMode(File file) throws IOException {
                if (file.isDirectory()) {
                    return 493;
                }
                if (file.exists()) {
                    return 420;
                }
                throw new FileNotFoundException(String.format("File '%s' not found.", file));
            }

            @Override
            public void chmod(File file, int mode) throws IOException {
                if (!file.exists()) {
                    throw new FileNotFoundException(String.format("File '%s' does not exist.", file));
                }
            }
        };
    }
}

