/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.internal.attributes.matching.AttributeMatchingCandidate;
import org.gradle.api.internal.attributes.matching.AttributeSelectionSchema;
import org.gradle.api.internal.attributes.matching.MultipleCandidateMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttributeMatcher
implements AttributeMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAttributeMatcher.class);
    private final AttributeSelectionSchema schema;
    private final InMemoryLoadingCache<CachedQuery, int[]> cachedQueries;
    private final InMemoryLoadingCache<MatchingCandidateCacheKey, Boolean> matchingCandidatesCache;

    public DefaultAttributeMatcher(AttributeSelectionSchema schema, InMemoryCacheFactory cacheFactory) {
        this.schema = schema;
        this.cachedQueries = cacheFactory.create(this::doMatchMultipleCandidates);
        this.matchingCandidatesCache = cacheFactory.create(this::doIsMatchingCandidate);
    }

    @Override
    public <T> boolean isMatchingValue(Attribute<T> attribute, T candidate, T requested) {
        return this.schema.matchValue(attribute, requested, candidate);
    }

    @Override
    public boolean isMatchingCandidate(ImmutableAttributes candidate, ImmutableAttributes requested) {
        MatchingCandidateCacheKey key = new MatchingCandidateCacheKey(candidate, requested);
        return (Boolean)this.matchingCandidatesCache.get((Object)key);
    }

    private boolean doIsMatchingCandidate(MatchingCandidateCacheKey k) {
        return this.allCommonAttributesSatisfy(k.candidate, k.requested, this.schema::matchValue);
    }

    @Override
    public boolean areMutuallyCompatible(ImmutableAttributes candidate, ImmutableAttributes requested) {
        return this.allCommonAttributesSatisfy(candidate, requested, this.schema::weakMatchValue);
    }

    private boolean allCommonAttributesSatisfy(ImmutableAttributes candidate, ImmutableAttributes requested, CoercingAttributeValuePredicate predicate) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return true;
        }
        for (ImmutableAttributesEntry requestedEntry : requested.getEntries()) {
            Attribute<?> typedAttribute;
            Attribute attribute = requestedEntry.getKey();
            ImmutableAttributesEntry candidateEntry = candidate.findEntry(attribute.getName());
            if (candidateEntry == null || predicate.test(typedAttribute = this.schema.tryRehydrate(attribute), requestedEntry, candidateEntry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<AttributeMatcher.MatchingDescription<?>> describeMatching(ImmutableAttributes candidate, ImmutableAttributes requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return Collections.emptyList();
        }
        CoercingAttributeValuePredicate matches = this.schema::matchValue;
        ImmutableCollection attributes = requested.getEntries();
        ArrayList result = new ArrayList(attributes.size());
        for (ImmutableAttributesEntry requestedEntry : attributes) {
            Attribute attribute = requestedEntry.getKey();
            ImmutableAttributesEntry candidateEntry = candidate.findEntry(attribute.getName());
            if (candidateEntry != null) {
                Attribute<?> typedAttribute = this.schema.tryRehydrate(attribute);
                boolean match = matches.test(typedAttribute, requestedEntry, candidateEntry);
                result.add(new AttributeMatcher.MatchingDescription(requestedEntry, candidateEntry, match));
                continue;
            }
            result.add(new AttributeMatcher.MatchingDescription(requestedEntry, candidateEntry, false));
        }
        return result;
    }

    @Override
    public <T extends AttributeMatchingCandidate> List<T> matchMultipleCandidates(List<? extends T> candidates, ImmutableAttributes requested) {
        AttributeMatchingExplanationBuilder explanationBuilder = AttributeMatchingExplanationBuilder.logging();
        if (candidates.isEmpty()) {
            explanationBuilder.noCandidates(requested);
            return ImmutableList.of();
        }
        if (candidates.size() == 1) {
            AttributeMatchingCandidate candidate = (AttributeMatchingCandidate)candidates.iterator().next();
            ImmutableAttributes candidateAttributes = candidate.getAttributes();
            if (this.isMatchingCandidate(candidateAttributes, requested)) {
                explanationBuilder.singleMatch(candidateAttributes, (Collection<ImmutableAttributes>)ImmutableList.of((Object)candidateAttributes), (AttributeContainerInternal)requested);
                return Collections.singletonList(candidate);
            }
            explanationBuilder.candidateDoesNotMatchAttributes(candidateAttributes, (AttributeContainerInternal)requested);
            return ImmutableList.of();
        }
        CachedQuery query = CachedQuery.from(requested, candidates);
        int[] indices = (int[])this.cachedQueries.get((Object)query);
        return CachedQuery.getMatchesFromCandidateIndices(indices, candidates);
    }

    private int[] doMatchMultipleCandidates(CachedQuery key) {
        AttributeMatchingExplanationBuilder explanationBuilder = AttributeMatchingExplanationBuilder.logging();
        int[] matches = new MultipleCandidateMatcher(this.schema, key.candidates, key.requestedAttributes, explanationBuilder).getMatches();
        LOGGER.debug("Selected matches {} from candidates {} for {}", new Object[]{Ints.asList((int[])matches), key.candidates, key.requestedAttributes});
        return matches;
    }

    private static class MatchingCandidateCacheKey {
        private final ImmutableAttributes candidate;
        private final ImmutableAttributes requested;
        private final int hashCode;

        public MatchingCandidateCacheKey(ImmutableAttributes candidate, ImmutableAttributes requested) {
            this.candidate = candidate;
            this.requested = requested;
            this.hashCode = 31 * candidate.hashCode() + requested.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchingCandidateCacheKey cacheKey = (MatchingCandidateCacheKey)o;
            return this.candidate.equals(cacheKey.candidate) && this.requested.equals(cacheKey.requested);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static interface CoercingAttributeValuePredicate {
        public <A> boolean test(Attribute<A> var1, A var2, A var3);

        default public <T> boolean test(Attribute<T> attribute, ImmutableAttributesEntry<?> requested, ImmutableAttributesEntry<?> candidate) {
            Object requestedValue = requested.coerce(attribute);
            Object candidateValue = candidate.coerce(attribute);
            return this.test(attribute, requestedValue, candidateValue);
        }
    }

    private static class CachedQuery {
        private final ImmutableAttributes requestedAttributes;
        private final ImmutableAttributes[] candidates;
        private final int hashCode;

        private CachedQuery(ImmutableAttributes requestedAttributes, ImmutableAttributes[] candidates) {
            this.requestedAttributes = requestedAttributes;
            this.candidates = candidates;
            this.hashCode = CachedQuery.computeHashCode(requestedAttributes, candidates);
        }

        private static int computeHashCode(ImmutableAttributes requestedAttributes, ImmutableAttributes[] candidates) {
            int hash = requestedAttributes.hashCode();
            for (ImmutableAttributes candidate : candidates) {
                hash = 31 * hash + candidate.hashCode();
            }
            return hash;
        }

        public static <T extends AttributeMatchingCandidate> CachedQuery from(ImmutableAttributes requestedAttributes, List<T> candidates) {
            int size = candidates.size();
            ImmutableAttributes[] attributes = new ImmutableAttributes[size];
            for (int i = 0; i < size; ++i) {
                attributes[i] = ((AttributeMatchingCandidate)candidates.get(i)).getAttributes();
            }
            return new CachedQuery(requestedAttributes, attributes);
        }

        private static <T extends AttributeMatchingCandidate> List<T> getMatchesFromCandidateIndices(int[] indices, List<? extends T> candidates) {
            if (indices.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<AttributeMatchingCandidate> matches = new ArrayList<AttributeMatchingCandidate>(indices.length);
            for (int index : indices) {
                matches.add((AttributeMatchingCandidate)candidates.get(index));
            }
            return matches;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedQuery that = (CachedQuery)o;
            return this.hashCode == that.hashCode && this.requestedAttributes.equals(that.requestedAttributes) && Arrays.equals(this.candidates, that.candidates);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "CachedQuery{requestedAttributes=" + this.requestedAttributes + ", candidates=" + Arrays.toString(this.candidates) + '}';
        }
    }
}

