/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;

public interface FileViewProvider
extends UserDataHolderEx,
Cloneable {
    @NotNull
    public PsiManager getManager();

    public Document getDocument();

    @NotNull
    public CharSequence getContents();

    @NotNull
    public VirtualFile getVirtualFile();

    @NotNull
    public Language getBaseLanguage();

    @NotNull
    public Set<Language> getLanguages();

    default public boolean hasLanguage(@NotNull Language language2) {
        if (language2 == null) {
            FileViewProvider.$$$reportNull$$$0(0);
        }
        return this.getLanguages().contains(language2);
    }

    public PsiFile getPsi(@NotNull Language var1);

    @NotNull
    public List<PsiFile> getAllFiles();

    public boolean isEventSystemEnabled();

    public boolean isPhysical();

    public long getModificationStamp();

    public boolean supportsIncrementalReparse(@NotNull Language var1);

    public void rootChanged(@NotNull PsiFile var1);

    public void beforeContentsSynchronized();

    public void contentsSynchronized();

    public FileViewProvider clone();

    @Nullable
    public PsiElement findElementAt(int var1);

    @Nullable
    public PsiReference findReferenceAt(int var1);

    @Nullable
    public PsiElement findElementAt(int var1, @NotNull Language var2);

    @Nullable
    public PsiElement findElementAt(int var1, @NotNull Class<? extends Language> var2);

    @Nullable
    public PsiReference findReferenceAt(int var1, @NotNull Language var2);

    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile var1);

    @NotNull
    public PsiFile getStubBindingRoot();

    @NotNull
    public FileType getFileType();

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/FileViewProvider", "hasLanguage"));
    }
}

