/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class GlobalSearchScopeUtil {
    @NotNull
    public static GlobalSearchScope toGlobalSearchScope(@NotNull SearchScope scope2, @NotNull Project project) {
        if (scope2 == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(1);
        }
        if (scope2 instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)scope2;
            if (globalSearchScope == null) {
                GlobalSearchScopeUtil.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = ReadAction.compute(() -> GlobalSearchScope.filesScope(project, GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)scope2)));
        if (globalSearchScope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    public static Set<VirtualFile> getLocalScopeFiles(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(4);
        }
        Set set = ReadAction.compute(() -> {
            LinkedHashSet files2 = new LinkedHashSet();
            for (PsiElement element : scope2.getScope()) {
                PsiFile file = element.getContainingFile();
                if (file == null) continue;
                ContainerUtil.addIfNotNull(files2, file.getVirtualFile());
                ContainerUtil.addIfNotNull(files2, file.getNavigationElement().getContainingFile().getVirtualFile());
            }
            return files2;
        });
        if (set == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScopeUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScopeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toGlobalSearchScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalScopeFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toGlobalSearchScope";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalScopeFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

