/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;

public final class KeyPasswordProviderFactory {
    private static final KeyPasswordProviderCreator DEFAULT = IdentityPasswordProvider::new;
    private static AtomicReference<KeyPasswordProviderCreator> INSTANCE = new AtomicReference<KeyPasswordProviderCreator>(DEFAULT);

    private KeyPasswordProviderFactory() {
    }

    @NonNull
    public static KeyPasswordProviderCreator getInstance() {
        return INSTANCE.get();
    }

    @NonNull
    public static KeyPasswordProviderCreator setInstance(KeyPasswordProviderCreator provider) {
        if (provider == null) {
            return INSTANCE.getAndSet(DEFAULT);
        }
        return INSTANCE.getAndSet(provider);
    }

    @FunctionalInterface
    public static interface KeyPasswordProviderCreator
    extends Function<CredentialsProvider, KeyPasswordProvider> {
    }
}

