/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.antlr.AntlrSourceDirectorySet;
import org.gradle.api.plugins.antlr.AntlrTask;
import org.gradle.api.plugins.antlr.internal.DefaultAntlrSourceDirectorySet;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.file.FilePathUtil;

public abstract class AntlrPlugin
implements Plugin<Project> {
    public static final String ANTLR_CONFIGURATION_NAME = "antlr";
    private final ObjectFactory objectFactory;

    @Inject
    public AntlrPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(final Project project) {
        project.getPluginManager().apply(JavaLibraryPlugin.class);
        Configuration antlrConfiguration = ((ProjectInternal)project).getConfigurations().resolvableDependencyScopeLocked(ANTLR_CONFIGURATION_NAME, conf -> conf.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)"antlr:antlr:2.7.7@jar"))));
        JavaPluginHelper.getJavaComponent((Project)project).getMainFeature().getApiConfiguration().extendsFrom(new Configuration[]{antlrConfiguration});
        project.getTasks().withType(AntlrTask.class).configureEach(antlrTask -> antlrTask.getConventionMapping().map("antlrClasspath", () -> project.getConfigurations().getByName(ANTLR_CONFIGURATION_NAME)));
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                AntlrSourceDirectorySet antlrSourceSet = AntlrPlugin.createAntlrSourceDirectorySet(((DefaultSourceSet)sourceSet).getDisplayName(), AntlrPlugin.this.objectFactory);
                sourceSet.getExtensions().add(AntlrSourceDirectorySet.class, AntlrPlugin.ANTLR_CONFIGURATION_NAME, (Object)antlrSourceSet);
                String srcDir = "src/" + sourceSet.getName() + "/antlr";
                antlrSourceSet.srcDir(srcDir);
                sourceSet.getAllSource().source((SourceDirectorySet)antlrSourceSet);
                String taskName = sourceSet.getTaskName("generate", "GrammarSource");
                String outputDirectoryName = project.getBuildDir() + "/generated-src/antlr/" + sourceSet.getName();
                File outputDirectory = new File(outputDirectoryName);
                TaskProvider antlrTask = project.getTasks().register(taskName, AntlrTask.class, task -> {
                    task.setDescription("Processes the " + sourceSet.getName() + " Antlr grammars.");
                    task.setSource((FileTree)antlrSourceSet);
                    task.setOutputDirectory(outputDirectory);
                });
                sourceSet.getJava().srcDir((Object)antlrTask.map(task -> {
                    String relativeOutputDirectory = project.relativePath((Object)task.getOutputDirectory());
                    return project.file((Object)AntlrPlugin.deriveGeneratedSourceRootDirectory(relativeOutputDirectory, task.getArguments()));
                }));
            }
        });
    }

    private static String deriveGeneratedSourceRootDirectory(String outputDirectoryPath, List<String> arguments) {
        int packageIndex;
        if (arguments.contains("-package") && (packageIndex = arguments.indexOf("-package")) + 1 < arguments.size()) {
            String packageRelativePath = arguments.get(packageIndex + 1).replace('.', '/');
            return FilePathUtil.maybeRemoveTrailingSegments((String)outputDirectoryPath, (String)packageRelativePath);
        }
        return outputDirectoryPath;
    }

    private static AntlrSourceDirectorySet createAntlrSourceDirectorySet(String parentDisplayName, ObjectFactory objectFactory) {
        String name = parentDisplayName + ".antlr";
        String displayName = parentDisplayName + " Antlr source";
        AntlrSourceDirectorySet antlrSourceSet = (AntlrSourceDirectorySet)objectFactory.newInstance(DefaultAntlrSourceDirectorySet.class, new Object[]{objectFactory.sourceDirectorySet(name, displayName)});
        antlrSourceSet.getFilter().include(new String[]{"**/*.g"});
        antlrSourceSet.getFilter().include(new String[]{"**/*.g4"});
        return antlrSourceSet;
    }
}

