/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import org.gradle.internal.time.Clock;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionEvent;
import org.gradle.launcher.daemon.server.health.gc.SlidingWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionCheck
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GarbageCollectionCheck.class);
    private final Clock clock;
    private final GarbageCollectorMXBean garbageCollectorMXBean;
    private final String heapMemoryPool;
    private final SlidingWindow<GarbageCollectionEvent> heapEvents;
    private final String nonHeapMemoryPool;
    private final SlidingWindow<GarbageCollectionEvent> nonHeapEvents;

    public GarbageCollectionCheck(Clock clock, GarbageCollectorMXBean garbageCollectorMXBean, String heapMemoryPool, SlidingWindow<GarbageCollectionEvent> heapEvents, String nonHeapMemoryPool, SlidingWindow<GarbageCollectionEvent> nonHeapEvents) {
        this.clock = clock;
        this.garbageCollectorMXBean = garbageCollectorMXBean;
        this.heapMemoryPool = heapMemoryPool;
        this.heapEvents = heapEvents;
        this.nonHeapMemoryPool = nonHeapMemoryPool;
        this.nonHeapEvents = nonHeapEvents;
    }

    @Override
    public void run() {
        try {
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                String poolName = memoryPoolMXBean.getName();
                if (memoryPoolMXBean.getType() == MemoryType.HEAP && poolName.equals(this.heapMemoryPool)) {
                    GarbageCollectionEvent latest = this.heapEvents.latest();
                    long currentCount = this.garbageCollectorMXBean.getCollectionCount();
                    if (latest == null || latest.getCount() != currentCount) {
                        this.heapEvents.slideAndInsert(new GarbageCollectionEvent(this.clock.getCurrentTime(), memoryPoolMXBean.getCollectionUsage(), currentCount));
                    }
                }
                if (memoryPoolMXBean.getType() != MemoryType.NON_HEAP || !poolName.equals(this.nonHeapMemoryPool)) continue;
                this.nonHeapEvents.slideAndInsert(new GarbageCollectionEvent(this.clock.getCurrentTime(), memoryPoolMXBean.getUsage(), -1L));
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Exception while checking garbage collection", t);
        }
    }
}

