/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class FtpResponseEncoder
extends ProtocolEncoderAdapter {
    private static final ThreadLocal<CharsetEncoder> ENCODER = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return StandardCharsets.UTF_8.newEncoder();
        }
    };

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        String value = message.toString();
        IoBuffer buf = IoBuffer.allocate((int)value.length()).setAutoExpand(true);
        buf.putString((CharSequence)value, ENCODER.get());
        buf.flip();
        out.write((Object)buf);
    }
}

