/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.CustomerAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.function.Supplier;

public class SimpleAuthenticationDetailsProvider
extends CustomerAuthenticationDetailsProvider
implements AuthenticationDetailsProvider,
RegionProvider {
    private final String tenantId;
    private final String userId;
    private final String fingerprint;
    private final char[] passphraseCharacters;
    private final Supplier<InputStream> privateKeySupplier;
    private final Region region;

    @ConstructorProperties(value={"tenantId", "userId", "fingerprint", "passphraseCharacters", "privateKeySupplier", "region"})
    SimpleAuthenticationDetailsProvider(String tenantId, String userId, String fingerprint, char[] passphraseCharacters, Supplier<InputStream> privateKeySupplier, Region region) {
        this.tenantId = tenantId;
        this.userId = userId;
        this.fingerprint = fingerprint;
        this.passphraseCharacters = passphraseCharacters;
        this.privateKeySupplier = privateKeySupplier;
        this.region = region;
    }

    public static SimpleAuthenticationDetailsProviderBuilder builder() {
        return new SimpleAuthenticationDetailsProviderBuilder();
    }

    @Override
    public InputStream getPrivateKey() {
        return this.privateKeySupplier.get();
    }

    @Override
    @Deprecated
    public String getPassPhrase() {
        return this.passphraseCharacters != null ? new String(this.passphraseCharacters) : null;
    }

    public String toString() {
        return String.format("SimpleAuthenticationDetailsProvider(tenantId=%s, userId=%s, fingerprint=%s, passphraseCharacters=%s, privateKeySupplier=%s)", this.tenantId, this.userId, this.fingerprint, this.passphraseCharacters != null ? "<provided>" : (Object)this.passphraseCharacters, this.privateKeySupplier);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.passphraseCharacters;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public static class SimpleAuthenticationDetailsProviderBuilder {
        private String tenantId;
        private String userId;
        private String fingerprint;
        private char[] passphraseCharacters;
        private Supplier<InputStream> privateKeySupplier;
        private Region region;

        SimpleAuthenticationDetailsProviderBuilder() {
        }

        public SimpleAuthenticationDetailsProviderBuilder passPhrase(String passPhrase) {
            return this.passphraseCharacters(passPhrase != null ? passPhrase.toCharArray() : null);
        }

        public String toString() {
            return String.format("SimpleAuthenticationDetailsProvider.SimpleAuthenticationDetailsProviderBuilder(tenantId=%s, userId=%s, fingerprint=%s, passphraseCharacters=%s, privateKeySupplier=%s)", this.tenantId, this.userId, this.fingerprint, this.passphraseCharacters != null ? "<provided>" : (Object)this.passphraseCharacters, this.privateKeySupplier);
        }

        public SimpleAuthenticationDetailsProviderBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SimpleAuthenticationDetailsProviderBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public SimpleAuthenticationDetailsProviderBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public SimpleAuthenticationDetailsProviderBuilder passphraseCharacters(char[] passphraseCharacters) {
            this.passphraseCharacters = passphraseCharacters;
            return this;
        }

        public SimpleAuthenticationDetailsProviderBuilder privateKeySupplier(Supplier<InputStream> privateKeySupplier) {
            this.privateKeySupplier = privateKeySupplier;
            return this;
        }

        public SimpleAuthenticationDetailsProviderBuilder region(Region region) {
            this.region = region;
            return this;
        }

        public SimpleAuthenticationDetailsProvider build() {
            return new SimpleAuthenticationDetailsProvider(this.tenantId, this.userId, this.fingerprint, this.passphraseCharacters, this.privateKeySupplier, this.region);
        }
    }
}

