/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.internal.AbstractTemplateRptPathProvider;
import com.oracle.bmc.auth.internal.EnvironmentRptPathProvider;
import com.oracle.bmc.auth.internal.ImdsRptPathProvider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRptPathProvider
extends AbstractTemplateRptPathProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRptPathProvider.class);
    private final Map<String, String> replacements;

    public DefaultRptPathProvider() {
        super(DefaultRptPathProvider.getPathTemplate());
        LOG.debug("A path provider was not specified, using DefaultRptPathProvider");
        this.replacements = this.buildReplacements();
    }

    @Override
    protected Map<String, String> getReplacements() {
        return this.replacements;
    }

    private static String getPathTemplate() {
        String pathTemplate = EnvironmentRptPathProvider.getPathTemplate();
        if (pathTemplate == null) {
            LOG.debug("Unable to get path template from {} env variable, using IMDS template", (Object)"OCI_RESOURCE_PRINCIPAL_RPT_PATH");
            pathTemplate = ImdsRptPathProvider.getPathTemplate();
        }
        LOG.debug("The path template is {}", (Object)pathTemplate);
        return pathTemplate;
    }

    private Map<String, String> buildReplacements() {
        Map<String, String> replacementMap = EnvironmentRptPathProvider.buildReplacements();
        if (replacementMap == null) {
            LOG.debug("Unable to get replacements from {} env variable, getting replacements from IMDS", (Object)"OCI_RESOURCE_PRINCIPAL_RPT_ID");
            replacementMap = ImdsRptPathProvider.buildReplacements();
        }
        LOG.debug("The replacement map is {}", replacementMap);
        return replacementMap;
    }
}

