/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AbstractFederationClient;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.GetResourcePrincipalSessionTokenRequest;
import com.oracle.bmc.auth.internal.GetResourcePrincipalTokenResponse;
import com.oracle.bmc.auth.internal.RptPathProvider;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePrincipalsFederationClient
extends AbstractFederationClient {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePrincipalsFederationClient.class);
    private final InstancePrincipalsAuthenticationDetailsProvider provider;
    private final RptPathProvider resourcePrincipalTokenPathProvider;

    public ResourcePrincipalsFederationClient(String resourcePrincipalTokenEndpoint, RptPathProvider resourcePrincipalTokenPathProvider, String resourcePrincipalSessionTokenEndpoint, SessionKeySupplier sessionKeySupplier, InstancePrincipalsAuthenticationDetailsProvider instancePrincipalsAuthenticationDetailsProvider, ClientConfigurator clientConfigurator, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        super(resourcePrincipalTokenEndpoint, resourcePrincipalSessionTokenEndpoint, sessionKeySupplier, instancePrincipalsAuthenticationDetailsProvider, clientConfigurator, circuitBreakerConfiguration);
        this.provider = instancePrincipalsAuthenticationDetailsProvider;
        this.resourcePrincipalTokenPathProvider = resourcePrincipalTokenPathProvider;
    }

    @Override
    protected SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting security token from the auth server");
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Keypair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        this.provider.refresh();
        GetResourcePrincipalTokenResponse getResourcePrincipalTokenResponse = this.prepareRptCall().method((Method)Method.GET).logger((Logger)ResourcePrincipalsFederationClient.LOG, (String)"ResourcePrincipalsFederationClient").appendPathPart((String)this.resourcePrincipalTokenPathProvider.getPath()).callSync().body;
        String servicePrincipalSessionToken = getResourcePrincipalTokenResponse.getServicePrincipalSessionToken();
        String resourcePrincipalToken = getResourcePrincipalTokenResponse.getResourcePrincipalToken();
        return this.requestSessionToken(new GetResourcePrincipalSessionTokenRequest(resourcePrincipalToken, servicePrincipalSessionToken, AuthUtils.base64EncodeNoChunking(publicKey)));
    }
}

