/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.internal;

import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.http.client.Options;
import com.oracle.bmc.internal.DefaultEndpointConfiguration;
import com.oracle.bmc.util.internal.StringUtils;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointBuilder.class);
    public static final String DEFAULT_ENDPOINT_TEMPLATE = "https://{serviceEndpointPrefix}.{region}.{secondLevelDomain}";
    private static final String ENDPOINT_TEMPLATE_FOR_REGION_WITH_DOT = "https://{endpointServiceName}.{region}";
    private static final Map<String, String> OVERRIDE_REGION_IDS = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createEndpoint(@Nonnull Service service, @Nonnull String regionId, @Nonnull Realm realm) {
        boolean realmSpecificEndpointTemplateDefined;
        String regionIdToUse;
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        Map<String, String> map = OVERRIDE_REGION_IDS;
        synchronized (map) {
            regionIdToUse = OVERRIDE_REGION_IDS.getOrDefault(regionId, regionId);
        }
        if (StringUtils.isNotBlank(regionId) && regionId.contains(".")) {
            String endpoint;
            if (StringUtils.isNotBlank(service.getEndpointServiceName())) {
                endpoint = DefaultEndpointConfiguration.builder(ENDPOINT_TEMPLATE_FOR_REGION_WITH_DOT).endpointServiceName(service.getEndpointServiceName()).regionId(regionIdToUse).build();
                LOG.debug("Endpoint created from dotted region {} using endpoint service name {}. Endpoint: {}", new Object[]{regionIdToUse, service.getEndpointServiceName(), endpoint});
            } else if (StringUtils.isNotBlank(service.getServiceEndpointTemplate())) {
                String serviceEndpointTemplate = service.getServiceEndpointTemplate();
                String endpointServiceNameFromTemplate = EndpointBuilder.getEndpointServiceNameFromTemplate(serviceEndpointTemplate);
                endpoint = DefaultEndpointConfiguration.builder(ENDPOINT_TEMPLATE_FOR_REGION_WITH_DOT).endpointServiceName(endpointServiceNameFromTemplate).regionId(regionIdToUse).build();
                LOG.debug("Endpoint created from dotted region {} using endpoint template {}. Endpoint: {}", new Object[]{regionIdToUse, ENDPOINT_TEMPLATE_FOR_REGION_WITH_DOT, endpoint});
            } else if (StringUtils.isNotBlank(service.getServiceEndpointPrefix())) {
                endpoint = DefaultEndpointConfiguration.builder(ENDPOINT_TEMPLATE_FOR_REGION_WITH_DOT).endpointServiceName(service.getServiceEndpointPrefix()).regionId(regionIdToUse).build();
                LOG.debug("Endpoint created from dotted region {} using service endpoint prefix {}. Endpoint: {}", new Object[]{regionIdToUse, service.getServiceEndpointPrefix(), endpoint});
            } else {
                throw new IllegalArgumentException("Unknown service: " + service.getServiceName());
            }
            return endpoint;
        }
        boolean useOfRealmSpecificEndpointTemplateEnabled = Options.getUseOfRealmSpecificEndpointTemplateByDefault();
        boolean bl = realmSpecificEndpointTemplateDefined = service.getServiceEndpointTemplateForRealmMap() != null && service.getServiceEndpointTemplateForRealmMap().containsKey(realm.getRealmId().toLowerCase(Locale.ROOT));
        if (useOfRealmSpecificEndpointTemplateEnabled) {
            if (realmSpecificEndpointTemplateDefined) {
                return EndpointBuilder.getRealmSpecificEndpointTemplate(regionIdToUse, service, realm);
            }
            LOG.debug("Realm-specific endpoint template not defined for realm {}, using non-realm-specific endpoint template instead.", (Object)realm.getRealmId());
        }
        return EndpointBuilder.getServiceEndpointTemplateToUse(regionIdToUse, service, realm);
    }

    public static String getRealmSpecificEndpointTemplate(String regionId, Service service, Realm realm) {
        String endpointTemplateToUse;
        Map<String, String> serviceEndpointTemplateForRealmMap = service.getServiceEndpointTemplateForRealmMap();
        if (serviceEndpointTemplateForRealmMap.containsKey(realm.getRealmId().toLowerCase(Locale.ROOT))) {
            endpointTemplateToUse = serviceEndpointTemplateForRealmMap.get(realm.getRealmId().toLowerCase(Locale.ROOT));
        } else {
            LOG.debug("Endpoint template not defined for {} realm, using non-realm-specific endpoint template instead", (Object)realm.getRealmId());
            endpointTemplateToUse = EndpointBuilder.getServiceEndpointTemplateToUse(regionId, service, realm);
        }
        LOG.debug("Setting endpoint template to: {}", (Object)endpointTemplateToUse);
        return DefaultEndpointConfiguration.builder(endpointTemplateToUse).regionId(regionId).serviceEndpointPrefix(service.getServiceEndpointPrefix()).secondLevelDomain(realm.getSecondLevelDomain()).build();
    }

    public static String getServiceEndpointTemplateToUse(String regionId, Service service, Realm realm) {
        String endpointTemplateToUse = StringUtils.isNotBlank(service.getServiceEndpointTemplate()) ? service.getServiceEndpointTemplate() : DEFAULT_ENDPOINT_TEMPLATE;
        LOG.debug("Setting endpoint template to: {}", (Object)endpointTemplateToUse);
        return DefaultEndpointConfiguration.builder(endpointTemplateToUse).regionId(regionId).serviceEndpointPrefix(service.getServiceEndpointPrefix()).secondLevelDomain(realm.getSecondLevelDomain()).build();
    }

    private static String getEndpointServiceNameFromTemplate(String serviceEndpointTemplate) {
        int doubleSlashPos = serviceEndpointTemplate.indexOf("//");
        int dotPos = serviceEndpointTemplate.indexOf(".", doubleSlashPos);
        if (doubleSlashPos == -1 || dotPos == -1) {
            throw new IllegalArgumentException("The service endpoint template " + serviceEndpointTemplate + " is not in the expected format. The expected format is " + DEFAULT_ENDPOINT_TEMPLATE);
        }
        return serviceEndpointTemplate.substring(doubleSlashPos + 2, dotPos);
    }

    public static String createEndpoint(@Nonnull Service service, @Nonnull Region region) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        return EndpointBuilder.createEndpoint(service, region.getRegionId(), region.getRealm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overrideRegionId(@Nonnull String regionId, @Nonnull String overrideRegionId) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (overrideRegionId == null) {
            throw new NullPointerException("overrideRegionId is marked non-null but is null");
        }
        Map<String, String> map = OVERRIDE_REGION_IDS;
        synchronized (map) {
            LOG.warn("Overriding regionId for regionId '{}' to '{}'", (Object)regionId, (Object)overrideRegionId);
            OVERRIDE_REGION_IDS.put(regionId, overrideRegionId);
        }
    }

    private EndpointBuilder() {
    }
}

